package gov.va.vinci.dart.db.impl;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.ReviewTemplate;
import gov.va.vinci.dart.db.ReviewTemplateDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.List;

import javax.persistence.Query;

public class ReviewTemplateDAOImpl extends HibernateDAO implements ReviewTemplateDAO {

	@Override
	public ReviewTemplate findById(final int reviewTemplateId) throws ObjectNotFoundException {
		Query q = createQuery("from ReviewTemplate where id=:rid");
		q.setParameter("rid", reviewTemplateId);
		return (ReviewTemplate)q.getSingleResult();
	}

	@Override
	public ReviewTemplate findByGroupId(final int groupId) throws ObjectNotFoundException {
		Query q = createQuery("from ReviewTemplate where reviewer.id=:gid");
		q.setParameter("gid", groupId);
		return (ReviewTemplate)q.getSingleResult();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<ReviewTemplate> listAll() {
		Query query = createQuery("from ReviewTemplate");
		return (List<ReviewTemplate>)query.getResultList();
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<ReviewTemplate> listAllActive() {
		Query query = createQuery("from ReviewTemplate where active=true");
		return (List<ReviewTemplate>)query.getResultList();
	}
}
